function resid = resid_th_n(theta_n, F_o, theta_o,beta, epsilon, alpha, xi, eta, ...
                             psi, lambda, nu, varphi,  gamma, delta, s_o, G_o, G_n)
                         
r       = 1/beta - (1-delta);
X_o     = 1/lambda * F_o * theta_o;
I_o     = (lambda*X_o*G_o^(xi-1))^(1/xi);
mu_1    = beta/(1-beta)*(eta-1)*psi*theta_n^(eta);
P       = mu_1 + eta*psi*theta_n^(eta-1);
mu_2    = lambda/(1-beta*(1-lambda)) * mu_1;
I_n     = (xi * G_n^(1-xi) * mu_2)^(1/(1-xi));
X_n     = 1/lambda * I_n^(xi) * G_n^(1-xi);
F_n     = 1/theta_n * lambda * X_n;
O       = theta_n * F_n + theta_o * F_o;
Y       = s_o^(-epsilon)*P^(epsilon)*O;
VA      = (1/(1-s_o)*(Y^((epsilon-1)/epsilon)-s_o*O^((epsilon-1)/epsilon)))^(epsilon/(epsilon-1));
L       = (r/varphi * (1-alpha)/alpha * VA^(1/alpha))^(1/(nu+1/alpha));
K       = VA^(1/alpha)*L^(1-1/alpha);
C       = Y - delta*K -I_n - I_o - psi*theta_n^(eta)*F_n - psi*theta_o^(eta)*F_o;

resid   = r - alpha*(1-s_o)*Y^(1/epsilon)...
            *K^((epsilon-1)/epsilon*alpha - 1)...
            *L^((epsilon-1)/epsilon*(1-alpha));
        
%         keyboard